<?php
include("admin/config/dbcon.php");

// Step 1: Fetch all stores
$sql = "SELECT id, sname as sname FROM store where url =''";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // print_r($row);
        $id = $row['id'];
        $sname = $row['sname'];

        // Step 2: Convert sname to slug
        $slug = strtolower(trim($sname));
        $slug = preg_replace('/[^a-z0-9]+/i', '-', $slug); // replace non-alphanumeric with -
        $slug = trim($slug, '-'); // remove extra dashes

        // Step 3: Check if slug already exists
        $unique_slug = $slug;
        $counter = 1;

        while (true) {
            $check = $conn->prepare("SELECT COUNT(*) as cnt FROM store WHERE url = ? AND id != ?");
            $check->bind_param("si", $unique_slug, $id);
            $check->execute();
            $result_check = $check->get_result()->fetch_assoc();

            if ($result_check['cnt'] == 0) {
                break; // unique slug found
            }

            $unique_slug = $slug . '-' . $counter;
            $counter++;
        }

        // Step 4: Update store record with unique slug
        $update = $conn->prepare("UPDATE store SET url = ? WHERE id = ?");
        $update->bind_param("si", $unique_slug, $id);
        $update->execute();

        echo "$sname → $unique_slug <br>";
    }
} else {
    echo "No stores found.";
}

$conn->close();
?>
