  <!-- Slick Carousel CSS -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css" />

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- Slick Carousel JS -->
  <script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', () => {
      // --- 1. DOM Elements ---
      const modal = document.getElementById('coupon-modal');
      const closeBtn = modal.querySelector('.close-btn');
      const copyBtn = document.getElementById('copy-btn');
      const couponText = document.getElementById('coupon-code-text');
      const modalTitle = document.getElementById('modal-title');
      const bookingLink = document.getElementById('booking-link');
      const openModalButtons = document.querySelectorAll('.js-open-modal');

      // --- 2. Modal Functions ---
      const openModal = (couponCard) => {
        const code = couponCard.getAttribute('data-coupon-code');
        const headline = couponCard.querySelector('.coupon-card__headline').textContent;
        const offerId = couponCard.getAttribute('data-offer-id');

        // Populate the modal content
        modalTitle.textContent = headline;
        couponText.textContent = code;

        // Dynamically set the booking link with the coupon
        bookingLink.href = `https://www.senatorhotels.com/booking?coupon=${code}&offer=${offerId}`;

        modal.style.display = 'flex'; // Show the modal
      };

      const closeModal = () => {
        modal.style.display = 'none'; // Hide the modal
      };

      // --- 3. Event Listeners ---

      // A. Open Modal when 'VIEW OFFER' is clicked
      openModalButtons.forEach(button => {
        button.addEventListener('click', (event) => {
          const couponCard = event.target.closest('.coupon-card');
          if (couponCard) {
            openModal(couponCard);
          }
        });
      });

      // B. Close Modal on 'X' click
      closeBtn.addEventListener('click', closeModal);

      // C. Close Modal on outside click
      window.addEventListener('click', (event) => {
        if (event.target === modal) {
          closeModal();
        }
      });

      // D. Copy Code Functionality
      copyBtn.addEventListener('click', () => {
        const codeToCopy = couponText.textContent;

        // Use the modern clipboard API
        navigator.clipboard.writeText(codeToCopy).then(() => {
          // Provide visual feedback
          copyBtn.textContent = 'Copied!'; // Translated feedback
          copyBtn.classList.add('btn--copied');

          // Reset button text after a short delay
          setTimeout(() => {
            copyBtn.textContent = 'COPY CODE'; // Translated original text
            copyBtn.classList.remove('btn--copied');
          }, 1500);
        }).catch(err => {
          console.error('Error copying the code: ', err); // Translated console message
          // Fallback for older browsers
          alert('Please copy the code manually: ' + codeToCopy); // Translated alert
        });
      });
    });
  </script>
  
  <script>
function isMobileDevice() {
    return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
}

       function delayWithRAF(durationMs, callback) {
                                let start = null;
                        
                                function frame(timestamp) {
                                    if (!start) start = timestamp;
                                    const elapsed = timestamp - start;
                                    if (elapsed >= durationMs) {
                                        callback();
                                    } else {
                                        requestAnimationFrame(frame);
                                    }
                                }
                        
                                requestAnimationFrame(frame);
                            }
    $(document).ready(function() {
        $('.show_coupon_btn_').on('click',function(e){
            e.preventDefault();
            var store_image = $(this).data('store_image');
            var name = $(this).data('name');
            var sname = $(this).data('sname');
            var terms = $(this).data('terms');
            var code = $(this).data('code');
            var tracking = $(this).data('tracking');
                
            // Agar tracking start nahi hota 'https://' se
            if (tracking && !tracking.startsWith('https://')) {
                // Agar start hota hai 'http://' se to usko replace karo
                if (tracking.startsWith('http://')) {
                    tracking = tracking.replace('http://', 'https://');
                } else {
                    // Warna seedha 'https://' prefix add karo
                    tracking = 'https://' + tracking;
                }
            }

            $('#coupon_modal_store_actual_image').attr('src',store_image);   
            $('#coupon-code-text').html(code);   
            $('#modal-title').html(name);   
            var coupon_id = $(this).data('coupon_id');
            if(coupon_id){
                var type="increase_clicks_for_coupon";
                $.ajax({
                    url:"<?php
                    echo $domain;
                    ?>inc/functions.php",
                    method:"post",
                    data:{type:type,
                        coupon_id:coupon_id,
                    },
                    success:function(response){
                        $('#clicks_times_used_'+coupon_id).html(''+response+' Used')
                        console.log(response);
                    }
                })
            }
            
            if(code){
                    if (navigator.clipboard) {
                        navigator.clipboard.writeText(code).then(function() {
                        //   $('#coupon_modal_coupon_code_copy_alert').css('display','block');
                        //  $('#coupon_modal_coupon_code_copy_alert').css('visibility','visible');
                        // setTimeout(function(){
                        //      $('#coupon_modal_coupon_code_copy_alert').css('display','none');
                        //  $('#coupon_modal_coupon_code_copy_alert').css('visibility','hidden');
                        // },1500);
                   
                    console.log('Coupon code copied to clipboard: ' + code);
        
                }).catch(function(err) {
                    console.error('Failed to copy code: ', err);
                });
            } else {
                // Fallback if clipboard API is not supported
                var tempInput = document.createElement('input');
                tempInput.value = code;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);
                //   $('#coupon_modal_coupon_code_copy_alert').css('display','block');
                //      $('#coupon_modal_coupon_code_copy_alert').css('visibility','visible');
                //     setTimeout(function(){
                //          $('#coupon_modal_coupon_code_copy_alert').css('display','none');
                //      $('#coupon_modal_coupon_code_copy_alert').css('visibility','hidden');
                //     },1500);
      
            }
                const a = document.createElement('a');
                a.href = tracking;
                a.target = "_blank";
                a.textContent = "Click to visit Google";
                a.style.display = "none"; // Hide the <a> element
                document.body.appendChild(a);
                
                if (isMobileDevice()) {
                    a.click();
                }

                delayWithRAF(1000, () => {
                    // $('#coupon_modal_backdrop_ovelay_background').show();
                    $('#coupon-modal').css("display","flex");
                });
                delayWithRAF(3000, () => {
                    if (isMobileDevice()) {

                    } else {
                        window.open(tracking, '_blank'); // Open in new tab
                    }
                });
              
            }else{
                window.open(tracking, '_blank');
            }
         
        })
        $('.coupon_modal_close_btn_').on('click',function(e){
            e.preventDefault();
              $('#coupon_modal_backdrop_ovelay_background').hide();
            $('#coupon_modal__').hide();
        })
        $('#coupon_modal_coupon__shop__now_btn').on('click',function(e){
            e.preventDefault();
           var code=  $('#coupon_modal_coupon__code_btn').html();
             if (navigator.clipboard) {
                navigator.clipboard.writeText(code).then(function() {
                       $('#coupon_modal_coupon_code_copy_alert').css('display','block');
                     $('#coupon_modal_coupon_code_copy_alert').css('visibility','visible');
                    setTimeout(function(){
                         $('#coupon_modal_coupon_code_copy_alert').css('display','none');
                     $('#coupon_modal_coupon_code_copy_alert').css('visibility','hidden');
                    },1500);
                   
                    console.log('Coupon code copied to clipboard: ' + code);
        
                }).catch(function(err) {
                    console.error('Failed to copy code: ', err);
                });
            } else {
                // Fallback if clipboard API is not supported
                var tempInput = document.createElement('input');
                tempInput.value = code;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);
                   $('#coupon_modal_coupon_code_copy_alert').css('display','block');
                     $('#coupon_modal_coupon_code_copy_alert').css('visibility','visible');
                    setTimeout(function(){
                         $('#coupon_modal_coupon_code_copy_alert').css('display','none');
                     $('#coupon_modal_coupon_code_copy_alert').css('visibility','hidden');
                    },1500);
      
            }
        })
   
    })
        $("#search_data_wrapper").hide()
        $("#search_posts_header").on("keyup", (function(e) {
        e.preventDefault();
        var s = $(this).val();
        $.ajax({
            url: "<?php
if (isset($_GET['name'])) {
    if (substr($_GET['name'], -1) === '/') {
        echo "../../";
    } else {
        echo "../";
    }
}
?><?php if(isset($_GET['page'])){ echo '../'; } ?>inc/functions.php",
            method: "post",
            data: {
                val: s,
                type: "Header_live_search",
                url_navigator: "<?php
if (isset($_GET['name'])) {
    if (substr($_GET['name'], -1) === '/') {
        echo "../../";
    } else {
        echo "../";
    }
}
?><?php if(isset($_GET['page'])){ echo '../'; } ?>"
            },
            success: function(e) {
                if(e!=0){
                     $("#search_data_wrapper").html(e), $("#search_data_wrapper").show();
                }else{
                     $("#search_data_wrapper").html(e), $("#search_data_wrapper").hide();
                }
               
            }
        })
}))
$("#success_or_failed_message").hide() 
$("#subscribe_email_section_button").on("click", (function(e) {
    e.preventDefault();
    var s = $("#footer_email").val();
    if (!/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/.test(s)) return $("#success_or_failed_message").html("<strong>Invalid email!</strong> Please enter a valid email address"), $("#success_or_failed_message").css("color", "red"),$("#success_or_failed_message").css("visibility", "visible"), $("#success_or_failed_message").css("text-align", "center"), $("#success_or_failed_message").show(), void setTimeout((function() {
        $("#success_or_failed_message").hide()
    }), 2e3);
    $.ajax({
        url: "<?php
if (isset($_GET['name'])) {
    if (substr($_GET['name'], -1) === '/') {
        echo "../../";
    } else {
        echo "../";
    }
}
?><?php if(isset($_GET['page'])){ echo '../'; } ?>inc/functions.php",
        method: "post",
        data: {
            val: s,
            type: "email_subscribe"
        },
        success: function(e) {
            1 == e && ($("#success_or_failed_message").html("Thank you for your subscription!"),
            $("#success_or_failed_message").css("color", "green"),$("#success_or_failed_message").css("visibility", "visible"), $("#success_or_failed_message").css("text-align", "center"), $("#success_or_failed_message").show(), $("#footer_email").val("")), 0 == e && ($("#success_or_failed_message").html("<strong>Oops!</strong> Something went wrong"), $("#success_or_failed_message").css("color", "red"), $("#success_or_failed_message").css("text-align", "center"), $("#success_or_failed_message").show()), setTimeout((function() {
                $("#success_or_failed_message").hide()
            }), 2e3)
        }
    })
}))

$("#main_header_humburger_button").on('click',function(e){
    e.preventDefault();
    $('#mobile_menu').toggle('1000');
})
$("#close_mob_menu_btn").on('click',function(e){
        e.preventDefault();
    $('#mobile_menu').toggle('1000');
});
$('#mobile_search_button').on('click',function(e){
    e.preventDefault();
    $(this).hide();
    $("#mobile_search_button_close").show();
    $('.main_header_logo_wrapper').hide();
    $('#main_header_search_wrapper').css('display','flex');
    $('#main_header_search_wrapper').css('justify-content','space-between');
});
$("#mobile_search_button_close").on('click',function(e){
        e.preventDefault();
   $(this).hide();
   $('#mobile_search_button').show();
    $('.main_header_logo_wrapper').show();
    $('#main_header_search_wrapper').css('display','none');
    $('#main_header_search_wrapper').css('justify-content','space-between');
});
</script>