<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>CouponCodeSale - Best Coupon Deals</title>
  <?php include("inc/links.php") ?>
  <style>
    :root {
      --primary-color: #FF5722;
      --light-bg: #F5F5F5;
      --text-dark: #222;
      --accent-gradient: linear-gradient(135deg, #f4f7fa, #f4f7fa);
    }

    body {
      background-color: var(--light-bg);
      font-family: "Poppins", sans-serif;
    }

    /* Top announcement bar */
    .top-bar {
      background: var(--accent-gradient);
      color: #000;
      text-align: center;
      padding: 6px;
      font-size: 14px;
    }

    /* Navbar */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
 .navbar-brand img {
      height: 55px;
    }

    .nav-link {
      color: #333 !important;
      font-weight: 500;
      margin: 0 6px;
      transition: 0.3s;
    }

    .nav-link:hover {
      color: var(--primary-color) !important;
    }

    /* Hero Section */
    .hero {
      background: var(--accent-gradient);
      padding: 80px 0;
      text-align: center;
      color: #000;
    }

    .hero h1 {
      font-weight: 700;
      font-size: 5.5vw;
      text-align: left;
    }

    .hero input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px 20px;
    }

    .hero button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Coupons Section */
    .coupon-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
      padding: 25px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .coupon-badge {
      background: var(--primary-color);
      color: #000;
      font-weight: 600;
      border-radius: 50px;
      padding: 6px 15px;
      display: inline-block;
      font-size: 0.9rem;
    }

    .coupon-btn {
      background: var(--accent-gradient);
      border: none;
      color: #000;
      font-weight: 600;
      border-radius: 8px;
      padding: 10px 20px;
      transition: 0.3s;
    }

    .coupon-btn:hover {
      background: #000;
      color: #fff;
    }

    /* Categories Section */
    .category-card {
      background: #fff;
      border-radius: 16px;
      text-align: center;
      padding: 25px;
      transition: 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .category-card:hover {
      background: var(--primary-color);
      color: #000;
      transform: translateY(-5px);
    }

    /* Newsletter */
    .newsletter {
      background: var(--accent-gradient);
      padding: 50px 0;
      text-align: center;
    }

    .newsletter input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px;
      width: 60%;
      max-width: 400px;
    }

    .newsletter button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Footer */
    footer {
      background: #111;
      color: #ccc;
      padding: 60px 0 20px;
    }

    footer h5 {
      color: var(--primary-color);
      margin-bottom: 20px;
    }

    footer a {
      color: #ccc;
      text-decoration: none;
      display: block;
      margin-bottom: 8px;
      transition: 0.3s;
    }

    footer a:hover {
      color: #fff;
    }

    .coupon-card h5 {
      white-space: nowrap;
      /* Force text to stay in a single line */
      overflow: hidden;
      /* Hide overflow text */
      text-overflow: ellipsis;
      /* Add "..." at the end */
      display: block;
    }

    .coupon-card p {
      min-height: 50px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      /* limit to 2 lines */
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  </style>
 <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #f5f5f5, #e9ecef);
      color: #333;
      /* min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center; */
    }

    .contact-container {
      background: rgba(255, 255, 255, 0.8);
      backdrop-filter: blur(8px);
      border-radius: 20px;
      box-shadow: 0 4px 30px rgba(0,0,0,0.1);
      padding: 50px 40px;
      width: 100%;
      max-width: 600px;
      text-align: center;
      animation: fadeIn 0.7s ease;
      margin: 50px auto;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .contact-container h2 {
      font-weight: 700;
      margin-bottom: 10px;
      color: #111;
    }

    .emails {
      display: flex;
      justify-content: center;
      gap: 25px;
      /*flex-wrap: wrap;*/
      margin-bottom: 35px;
    }

    .emails a {
      text-decoration: none;
      color: #000;
      font-weight: 500;
      border: 2px solid #FF5722;
      padding: 8px 18px;
      border-radius: 50px;
      transition: all 0.3s ease;
    }

    .emails a:hover {
      background: #FF5722;
      color: #fff;
    }

    .form-control {
      border-radius: 12px;
      border: 1px solid #ccc;
      padding: 12px 15px;
      font-size: 15px;
    }

    .btn-custom {
      background-color: #FF5722;
      color: #fff;
      border-radius: 12px;
      font-weight: 600;
      width: 100%;
      padding: 12px;
      transition: all 0.3s ease;
      border: none;
    }

    .btn-custom:hover {
      background-color: #003366;
           color: #fff;
      transform: translateY(-2px);
    }

    .form-label {
      font-weight: 600;
    }
  </style>
</head>

<body>
  <!-- Announcement -->
    <?php include("inc/topbar.php"); ?>
  <!-- Navbar -->
    <?php include("inc/header.php"); ?>
 <div class="contact-container">
    <h2>Contact Us</h2>
    <p class="text-muted mb-4">Need assistance? Reach out through the form or email us anytime.</p>

    <!-- Emails -->
    <div class="emails">
      <a href="mailto:couponcodesale@gmail.com">couponcodesale@gmail.com</a>
      <a href="mailto:admin@couponcodesale.com">admin@couponcodesale.com</a>
    </div>

    <!-- Contact Form -->
    <form>
      <div class="mb-3 text-start">
        <label class="form-label">Your Name</label>
        <input type="text" class="form-control" id="name" placeholder="Enter your name" required>
      </div>

      <div class="mb-3 text-start">
        <label class="form-label">Email Address</label>
        <input type="email" class="form-control" id="email" placeholder="you@example.com" required>
      </div>
 <div class="mb-3 text-start">
        <label class="form-label">Phone</label>
        <input type="tel" class="form-control" id="phone" placeholder="Phone" required>
      </div>
      <div class="mb-3 text-start">
        <label class="form-label">Message</label>
        <textarea class="form-control" id="comment" rows="5" placeholder="Write your message here..." required></textarea>
      </div>

      <button type="submit" class="btn btn-custom mt-2" id="send_message_button">Send Message</button>
      <p id="contaact_form_submission_msg"></p>
    </form>
  </div>
  <!-- Footer -->

<?php include("inc/footer.php"); ?>

<?php include("inc/modals.php"); ?>
<?php include("inc/footer_lnks.php"); ?>
     <script>
           function validateEmail(email) {
            // Regular expression for validating an email format
            var regex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
        
            // Test the email using the regex
            return regex.test(email);
        }
        $(document).ready(function(){
            
            $('#contaact_form_submission_msg').hide();
            $('#send_message_button').on('click',function(e){
                e.preventDefault();
                var comment= $('#comment').val();
                var phone=$('#phone').val();
                var email=$('#email').val();
                var name=$('#name').val();
                var type="contact_Form_submission";
                var url_navigator="<?php if(isset($_GET['name'])){ echo '../'; } ?><?php if(isset($_GET['page'])){ echo '../'; } ?>";

                if (validateEmail(email)) {
                    $.ajax({
                        url:"inc/functions.php",
                        method:"post",
                        data:{
                            comment:comment,
                            phone:phone,
                            email:email,
                            name:name,
                            type:type
                        },
                        success:function(response){
                             $('#contaact_form_submission_msg').css('margin-bottom',"10px");
                               $('#contaact_form_submission_msg').css('text-align',"left");
                            if(response==1){

                                $('#contaact_form_submission_msg').html('Thank you for contacting us. We will contact you shortly.');
                                $('#contaact_form_submission_msg').css('color',"green");
                                $('#contaact_form_submission_msg').show();
                                    $('#comment').val('');
                                    $('#phone').val('');
                                    $('#email').val('');
                                    $('#name').val('');
                                setTimeout(function(){
                                    $('#contaact_form_submission_msg').hide();
                                },5000);
                            }
                            if(response==0){
                                $('#contaact_form_submission_msg').html('Oops! Something went wrong');
                                $('#contaact_form_submission_msg').css('color',"red");
                                $('#contaact_form_submission_msg').show();
                                setTimeout(function(){
                                    $('#contaact_form_submission_msg').hide();
                                },5000);
                            }
                        }
                    })
                } else {
                    $('#contaact_form_submission_msg').html('Invalid email! Please enter a valid email address');
                    $('#contaact_form_submission_msg').css('color',"red");
                    $('#contaact_form_submission_msg').show();
                    setTimeout(function(){
                        $('#contaact_form_submission_msg').hide();
                    },5000);
                }
          

            })
        })
    </script>

</body>

</html>