<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>CouponCodeSale - Best Coupon Deals</title>
  <?php include("inc/links.php") ?>
  <style>
    :root {
      --primary-color: #FF5722;
      --light-bg: #F5F5F5;
      --text-dark: #222;
      --accent-gradient: linear-gradient(135deg, #f4f7fa, #f4f7fa);
    }

    body {
      background-color: var(--light-bg);
      font-family: "Poppins", sans-serif;
    }

    /* Top announcement bar */
    .top-bar {
      background: var(--accent-gradient);
      color: #000;
      text-align: center;
      padding: 6px;
      font-size: 14px;
    }

    /* Navbar */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
 .navbar-brand img {
      height: 55px;
    }
    .nav-link {
      color: #333 !important;
      font-weight: 500;
      margin: 0 6px;
      transition: 0.3s;
    }

    .nav-link:hover {
      color: var(--primary-color) !important;
    }

    /* Hero Section */
    .hero {
      background: var(--accent-gradient);
      padding: 80px 0;
      text-align: center;
      color: #000;
    }

    .hero h1 {
      font-weight: 700;
      font-size: 5.5vw;
      text-align: left;
    }

    .hero input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px 20px;
    }

    .hero button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Coupons Section */
    .coupon-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
      padding: 25px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .coupon-badge {
      background: var(--primary-color);
      color: #000;
      font-weight: 600;
      border-radius: 50px;
      padding: 6px 15px;
      display: inline-block;
      font-size: 0.9rem;
    }

    .coupon-btn {
      background: var(--accent-gradient);
      border: none;
      color: #000;
      font-weight: 600;
      border-radius: 8px;
      padding: 10px 20px;
      transition: 0.3s;
    }

    .coupon-btn:hover {
      background: #000;
      color: #fff;
    }

    /* Categories Section */
    .category-card {
      background: #fff;
      border-radius: 16px;
      text-align: center;
      padding: 25px;
      transition: 0.3s;
      flex-direction: column;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .category-card:hover {
      /*background: var(--primary-color);*/
      color: #000;
      transform: translateY(-5px);
    }

    /* Newsletter */
    .newsletter {
      background: var(--accent-gradient);
      padding: 50px 0;
      text-align: center;
    }

    .newsletter input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px;
      width: 60%;
      max-width: 400px;
    }

    .newsletter button {
      border-radius: 0 5px 5px 0;
      background: #000;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Footer */
    footer {
      background: #111;
      color: #ccc;
      padding: 60px 0 20px;
    }

    footer h5 {
      color: var(--primary-color);
      margin-bottom: 20px;
    }

    footer a {
      color: #ccc;
      text-decoration: none;
      display: block;
      margin-bottom: 8px;
      transition: 0.3s;
    }

    footer a:hover {
      color: #fff;
    }

    .coupon-card h5 {
      white-space: nowrap;
      /* Force text to stay in a single line */
      overflow: hidden;
      /* Hide overflow text */
      text-overflow: ellipsis;
      /* Add "..." at the end */
      display: block;
    }

    .coupon-card p {
      min-height: 50px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      /* limit to 2 lines */
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  </style>
   <style>
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #F5F5F5;
      color: #333;
    }

    .page-title {
      text-align: center;
      font-weight: 700;
      margin: 50px 0 15px;
      color: #111;
    }

    .search-bar {
      max-width: 500px;
      margin: 0 auto 40px;
      position: relative;
    }

    .search-bar input {
      border-radius: 50px;
      padding: 12px 20px 12px 45px;
      border: 1px solid #ddd;
      width: 100%;
      font-size: 15px;
    }

    .search-bar i {
      position: absolute;
      top: 12px;
      left: 18px;
      color: #999;
      font-size: 18px;
    }

    .category-card {
      text-align: center;
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 2px 15px rgba(0,0,0,0.06);
      padding: 25px 10px;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .category-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 6px 25px rgba(0,0,0,0.1);
    }

    .category-card::after {
      content: "";
      position: absolute;
      bottom: 0;
      left: 0;
      width: 0%;
      height: 3px;
      background-color: #FF5722;
      transition: width 0.3s ease;
    }

    .category-card:hover::after {
      width: 100%;
    }

    .category-img {
      width: 70px;
      height: 70px;
      border-radius: 50%;
      border: 3px solid #FF5722;
      object-fit: cover;
      margin-bottom: 12px;
    }

    .category-title {
      font-weight: 600;
      font-size: 1rem;
      color: #111;
    }

    .pagination {
      justify-content: center;
      margin-top: 40px;
    }

    .pagination .page-link {
      color: #000;
      border-radius: 8px;
    }

    .pagination .active .page-link {
      background-color: #FF5722;
      border-color: #FF5722;
      color: #fff;
    }
  </style>
</head>

<body>
  <!-- Announcement -->
    <?php include("inc/topbar.php"); ?>
  <!-- Navbar -->
    <?php include("inc/header.php"); ?>
 
  <div class="container py-5">
    <h2 class="page-title">All Categories</h2>

    <!-- 🔍 Search Bar -->
    <div class="search-bar">
      <i class="bi bi-search"></i>
      <input type="text" id="searchInput" placeholder="Search categories...">
    </div>

    <!-- 🖼️ Categories Grid -->
    <div class="row g-4" id="categoryContainer">
      <!-- Example Cards -->
          <?php
        $Q="SELECT * FROM category order by rand()";
        $re=mysqli_query($conn,$Q);
        while($row=mysqli_fetch_assoc($re)){
          ?>
                <div class="col-6 col-sm-4 col-md-3 col-lg-2 category-item">
        <a href="category/<?php echo $row['url']; ?>" class="text-decoration-none">
          <div class="category-card">
            <img src="./admin/img/new/category/<?php echo $row['c_img']; ?>" alt="Fashion" class="category-img">
            <div class="category-title"><?php echo $row['c_name']; ?></div>
          </div>
        </a>
      </div>
       
          <?php
        }
        ?>


     
  
      <!-- Add more categories as needed -->
    </div>

    <!-- 🔢 Pagination -->
    <nav>
      <ul class="pagination mt-4" id="pagination"></ul>
    </nav>
  </div>
  <!-- Footer -->

<?php include("inc/footer.php"); ?>

<?php include("inc/modals.php"); ?>
<?php include("inc/footer_lnks.php"); ?>
 <script>
    // ✅ SEARCH FUNCTIONALITY
    const searchInput = document.getElementById("searchInput");
    const categoryItems = document.querySelectorAll(".category-item");

    searchInput.addEventListener("input", function () {
      const searchValue = this.value.toLowerCase();
      categoryItems.forEach(item => {
        const title = item.querySelector(".category-title").textContent.toLowerCase();
        item.style.display = title.includes(searchValue) ? "block" : "none";
      });
    });

    // ✅ SIMPLE PAGINATION
    const itemsPerPage = 18;
    const container = document.getElementById("categoryContainer");
    const pagination = document.getElementById("pagination");
    const allItems = Array.from(container.children);
    let currentPage = 1;
    const totalPages = Math.ceil(allItems.length / itemsPerPage);

    function showPage(page) {
      allItems.forEach((item, index) => {
        item.style.display = (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) ? "block" : "none";
      });
    }

    function setupPagination() {
      pagination.innerHTML = "";
      for (let i = 1; i <= totalPages; i++) {
        const li = document.createElement("li");
        li.classList.add("page-item");
        if (i === currentPage) li.classList.add("active");
        li.innerHTML = `<a class="page-link" href="#">${i}</a>`;
        li.addEventListener("click", (e) => {
          e.preventDefault();
          currentPage = i;
          showPage(i);
          setupPagination();
        });
        pagination.appendChild(li);
      }
    }

    showPage(currentPage);
    setupPagination();
  </script>
</body>

</html>