<?php
include('config/dbcon.php');
if (isset($_POST['sname'])) {
    $sname = $_POST['sname'];

    // Step 1: Convert to slug
    $slug = strtolower(trim($sname));
    $slug = preg_replace('/[^a-z0-9]+/i', '-', $slug);
    $slug = trim($slug, '-');

    // Step 2: Check uniqueness
    $unique_slug = $slug;
    $counter = 1;

    while (true) {
        $check = $conn->prepare("SELECT COUNT(*) as cnt FROM category WHERE url = ?");
        $check->bind_param("s", $unique_slug);
        $check->execute();
        $result = $check->get_result()->fetch_assoc();

        if ($result['cnt'] == 0) {
            break;
        }

        $unique_slug = $slug . '-' . $counter;
        $counter++;
    }

    echo $unique_slug;
}
?>
