<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>CouponCodeSale - Best Coupon Deals</title>
  <?php include("inc/links.php") ?>
  <style>
    :root {
      --primary-color: #FF5722;
      --light-bg: #F5F5F5;
      --text-dark: #222;
      --accent-gradient: linear-gradient(135deg, #f4f7fa, #f4f7fa);
    }

    body {
      background-color: var(--light-bg);
      font-family: "Poppins", sans-serif;
    }

    /* Top announcement bar */
    .top-bar {
      background: var(--accent-gradient);
      color: #000;
      text-align: center;
      padding: 6px;
      font-size: 14px;
    }

    /* Navbar */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .navbar-brand img {
      height: 55px;
    }

    .nav-link {
      color: #333 !important;
      font-weight: 500;
      margin: 0 6px;
      transition: 0.3s;
    }

    .nav-link:hover {
      color: var(--primary-color) !important;
    }

    /* Hero Section */
    .hero {
      background: var(--accent-gradient);
      padding: 80px 0;
      text-align: center;
      color: #000;
    }

    .hero h1 {
      font-weight: 700;
      font-size: 5.5vw;
      text-align: left;
    }

    .hero input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px 20px;
    }

    .hero button {
      border-radius: 0 5px 5px 0;
      background: #003366;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Coupons Section */
    .coupon-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
      padding: 25px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .coupon-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .coupon-badge {
      background: var(--primary-color);
      color: #000;
      font-weight: 600;
      border-radius: 50px;
      padding: 6px 15px;
      display: inline-block;
      font-size: 0.9rem;
    }

    .coupon-btn {
      background: var(--accent-gradient);
      border: none;
      color: #000;
      font-weight: 600;
      border-radius: 8px;
      padding: 10px 20px;
      transition: 0.3s;
    }

    .coupon-btn:hover {
      background: #000;
      color: #fff;
    }

    /* Categories Section */
    .category-card {
      background: #fff;
      border-radius: 16px;
      text-align: center;
      padding: 25px;
      transition: 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .category-card:hover {
      background: var(--primary-color);
      color: #000;
      transform: translateY(-5px);
    }

    /* Newsletter */
    .newsletter {
      background: var(--accent-gradient);
      padding: 50px 0;
      text-align: center;
    }

    .newsletter input {
      border-radius: 5px 0 0 5px;
      border: none;
      padding: 15px;
      width: 60%;
      max-width: 400px;
    }

    .newsletter button {
      border-radius: 0 5px 5px 0;
      background: #003366;
      color: #fff;
      border: none;
      padding: 15px 25px;
    }

    /* Footer */
    footer {
      background: #111;
      color: #ccc;
      padding: 60px 0 20px;
    }

    footer h5 {
      color: var(--primary-color);
      margin-bottom: 20px;
    }

    footer a {
      color: #ccc;
      text-decoration: none;
      display: block;
      margin-bottom: 8px;
      transition: 0.3s;
    }

    footer a:hover {
      color: #fff;
    }

    .coupon-card h5 {
      white-space: nowrap;
      /* Force text to stay in a single line */
      overflow: hidden;
      /* Hide overflow text */
      text-overflow: ellipsis;
      /* Add "..." at the end */
      display: block;
    }

    .coupon-card p {
      min-height: 50px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      /* limit to 2 lines */
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  </style>


    <style>
        /*body{*/
        /*    background: #f8f9fa;*/
        /*}*/
        .hero-section {
            background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)),
                        url('https://images.unsplash.com/photo-1531297484001-80022131f5a1?auto=format&fit=crop&w=1200&q=80');
            background-size: cover;
            background-position: center;
            padding: 120px 0;
            color: #fff;
            text-align: center;
        }
        .about-card {
            border-radius: 15px;
            padding: 35px;
            background: #fff;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .team-card img {
            border-radius: 50%;
            width: 110px;
            height: 110px;
            object-fit: cover;
        }
        .team-card {
            background: #fff;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        footer{
            background:#111;
            color:#ddd;
            padding:35px 0;
        }
    </style>
</head>

<body>
  <!-- Announcement -->
    <?php include("inc/topbar.php"); ?>
  <!-- Navbar -->
    <?php include("inc/header.php"); ?>
 <!-- HERO SECTION -->
    <div class="hero-section">
        <h1 class="display-4 fw-bold">About Us</h1>

    </div>

    <!-- ABOUT CONTENT -->
    <div class="container my-5">
        <div class="about-card">
            <h2 class="fw-bold mb-3">Who We Are</h2>
            <p class="text-muted">
             At CouponCodeSale, we help smart shoppers save money every day. Our platform brings together the latest coupon codes, promo codes, discount deals, and exclusive offers from thousands of online stores.
We work continuously to verify deals so our users always get reliable, active, and money-saving discounts without wasting time searching the internet.<br><br>
Whether you shop for fashion, electronics, travel, beauty, or everyday essentials — CouponCodeSale is your trusted partner for smarter and more affordable online shopping.
            </p>
        </div>
    </div>

    <!-- MISSION & VISION -->
    <div class="container my-5">
        <div class="row g-4">
            <div class="col-md-6">
                <div class="about-card">
                    <h3 class="fw-bold">Our Mission</h3>
                    <p class="text-muted">
                      Our mission is simple:<br>
                      To make online shopping affordable for everyone.<br><br>
                      We aim to deliver:
                      <ul>
                          <li class="text-muted">Verified and active coupons</li>
                          <li class="text-muted">Daily updated deals</li>
                          <li class="text-muted">Savings across thousands of top stores</li>
                          <li class="text-muted">A smooth and easy browsing experience</li>
                      </ul>
                      
                    </p>
                    <p class="text-muted">We want every visitor to save money with confidence, knowing the deals they find on our site are genuine and up to date.</p>
                </div>
            </div>

            <div class="col-md-6">
                <div class="about-card">
                    <h3 class="fw-bold">Our Vision</h3>
                    <p class="text-muted">
                       We envision CouponCodeSale becoming one of the most trusted global destinations for online savings.
Our goal is to build a platform where shoppers can:
  <ul>
                          <li class="text-muted">Discover the best deals in seconds</li>
                          <li class="text-muted">Enjoy a seamless and transparent savings experience</li>
                          <li class="text-muted">Make smarter decisions with reliable, high-quality content</li>
                      </ul>
                    </p>
                    <br>
                    <p class="text-muted">Ultimately, we aim to create a community of shoppers who save more every time they shop online.</p><br>
                </div>
            </div>
        </div>
    </div>


    <!-- Footer -->
    <?php include("inc/footer.php"); ?>
    <?php include("inc/modals.php"); ?>
    <?php include("inc/footer_lnks.php"); ?>
    <!-- Slick Init Script -->
    <script>
    $(document).ready(function() {
      $('.store-slider').slick({
        slidesToShow: 6,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 1500,
        arrows: true,
        dots: false,
        pauseOnHover: false,
        responsive: [{
            breakpoint: 1200,
            settings: {
              slidesToShow: 5
            }
          },
          {
            breakpoint: 992,
            settings: {
              slidesToShow: 4
            }
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: 3
            }
          },
          {
            breakpoint: 576,
            settings: {
              slidesToShow: 2
            }
          }
        ]
      });
    });
  </script>

</body>

</html>